/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.jeitweaker;

import com.blamejared.jeitweaker.api.IngredientEnumerator;
import com.blamejared.jeitweaker.api.IngredientEnumeratorRegistration;
import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.api.IngredientTypeHolder;
import com.blamejared.jeitweaker.api.IngredientTypeRegistration;
import com.blamejared.jeitweaker.api.JeiTweakerPlugin;
import com.blamejared.jeitweaker.api.JeiTweakerPluginProvider;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.Mekanism;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

@JeiTweakerPlugin
public class MekanismJeiTweakerPluginProvider
implements JeiTweakerPluginProvider {
    public static final IngredientTypeHolder<ICrTChemicalStack.ICrTGasStack, GasStack> GAS = MekanismJeiTweakerPluginProvider.createTypeHolder("gas", ICrTChemicalStack.ICrTGasStack.class, GasStack.class, CrTChemicalStack.CrTGasStack::new);
    public static final IngredientTypeHolder<ICrTChemicalStack.ICrTInfusionStack, InfusionStack> INFUSION = MekanismJeiTweakerPluginProvider.createTypeHolder("infusion", ICrTChemicalStack.ICrTInfusionStack.class, InfusionStack.class, CrTChemicalStack.CrTInfusionStack::new);
    public static final IngredientTypeHolder<ICrTChemicalStack.ICrTPigmentStack, PigmentStack> PIGMENT = MekanismJeiTweakerPluginProvider.createTypeHolder("pigment", ICrTChemicalStack.ICrTPigmentStack.class, PigmentStack.class, CrTChemicalStack.CrTPigmentStack::new);
    public static final IngredientTypeHolder<ICrTChemicalStack.ICrTSlurryStack, SlurryStack> SLURRY = MekanismJeiTweakerPluginProvider.createTypeHolder("slurry", ICrTChemicalStack.ICrTSlurryStack.class, SlurryStack.class, CrTChemicalStack.CrTSlurryStack::new);

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>> IngredientTypeHolder<CRT_STACK, STACK> createTypeHolder(String type, Class<CRT_STACK> crtClass, Class<STACK> clazz, Function<STACK, CRT_STACK> converter) {
        return IngredientTypeHolder.of((ResourceLocation)Mekanism.rl(type), crtClass, clazz, ICrTChemicalStack::getInternal, converter, ICrTChemicalStack::getRegistryName, ICrTChemicalStack::isEqual);
    }

    public void registerIngredientTypes(IngredientTypeRegistration registration) {
        GAS.registerTo(registration);
        INFUSION.registerTo(registration);
        PIGMENT.registerTo(registration);
        SLURRY.registerTo(registration);
    }

    public void registerIngredientEnumerators(IngredientEnumeratorRegistration registration) {
        this.addEnumerators(registration, GAS, MekanismAPI.gasRegistry());
        this.addEnumerators(registration, INFUSION, MekanismAPI.infuseTypeRegistry());
        this.addEnumerators(registration, PIGMENT, MekanismAPI.pigmentRegistry());
        this.addEnumerators(registration, SLURRY, MekanismAPI.slurryRegistry());
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>> void addEnumerators(IngredientEnumeratorRegistration registration, IngredientTypeHolder<CRT_STACK, STACK> typeHolder, IForgeRegistry<CHEMICAL> registry) {
        registration.registerEnumerator(typeHolder.get(), IngredientEnumerator.ofJei((IngredientType)typeHolder.get(), registry.getValues().stream().map(chemical -> ChemicalUtil.withAmount(chemical, 1000L)).toList()));
    }
}

